import requests
import pprint
import sys

from connectorAPI.resourceapi import ResourceApi

provider_url = "https://localhost:8080"
dataValue = "SOME LONG VALUE"

if __name__ == "__main__":
    argv = sys.argv[1:]
    if len(argv) >= 1:
        provider_url = argv[0]
        print("Setting provider_url to:", provider_url)
    if len(argv) >= 2:
        dataValue = argv[1]
        print("Setting dataValue to:", dataValue)


print("Starting script")

# Suppress ssl verification warning
requests.packages.urllib3.disable_warnings()

# Provider
provider = ResourceApi(provider_url)

## Create resources
catalog = provider.create_catalog()
offers = provider.create_offered_resource()
representation = provider.create_representation()
artifact = provider.create_artifact(data={"value": dataValue})
contract = provider.create_contract()
use_rule = provider.create_rule()

## Link resources
provider.add_resource_to_catalog(catalog, offers)
provider.add_representation_to_resource(offers, representation)
provider.add_artifact_to_representation(representation, artifact)
provider.add_contract_to_resource(offers, contract)
provider.add_rule_to_contract(contract, use_rule)

print("Created provider resources")
